/*
 * Decompiled with CFR 0.152.
 */
package net.rgielen.fxweaver.spring;

import java.util.Optional;
import javafx.scene.Node;
import net.rgielen.fxweaver.core.FxControllerAndView;
import net.rgielen.fxweaver.core.FxWeaver;
import net.rgielen.fxweaver.core.LazyFxControllerAndView;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.core.ResolvableType;

public class InjectionPointLazyFxControllerAndViewResolver {
    private final FxWeaver fxWeaver;

    public InjectionPointLazyFxControllerAndViewResolver(FxWeaver fxWeaver) {
        this.fxWeaver = fxWeaver;
    }

    public <C, V extends Node> FxControllerAndView<C, V> resolve(InjectionPoint injectionPoint) {
        ResolvableType resolvableType = this.findResolvableType(injectionPoint);
        if (resolvableType == null) {
            throw new IllegalArgumentException("No ResolvableType found");
        }
        try {
            Class controllerClass = resolvableType.getGenerics()[0].resolve();
            return new LazyFxControllerAndView(() -> this.fxWeaver.load(controllerClass));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Generic controller type not resolvable for injection point " + String.valueOf(injectionPoint), e);
        }
    }

    private ResolvableType findResolvableType(InjectionPoint injectionPoint) {
        return Optional.ofNullable(injectionPoint.getMethodParameter()).map(ResolvableType::forMethodParameter).orElse(Optional.ofNullable(injectionPoint.getField()).map(ResolvableType::forField).orElse(null));
    }
}

