/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.structure.cell;

import java.awt.geom.Point2D;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.drawing.cell.ImageCellDrawer;
import org.vandeseer.easytable.structure.cell.AbstractCell;

public class ImageCell
extends AbstractCell {
    private final float scale;
    @NonNull
    private PDImageXObject image;
    private float maxHeight;

    @Override
    public float getMinHeight() {
        return this.getFitSize().y + this.getVerticalPadding() > super.getMinHeight() ? this.getFitSize().y + this.getVerticalPadding() : super.getMinHeight();
    }

    @Override
    protected Drawer createDefaultDrawer() {
        return new ImageCellDrawer(this);
    }

    public Point2D.Float getFitSize() {
        Point2D.Float sizes = new Point2D.Float();
        float scaledWidth = (float)this.image.getWidth() * this.getScale();
        float scaledHeight = (float)this.image.getHeight() * this.getScale();
        float resultingWidth = this.getWidth() - this.getHorizontalPadding();
        if (scaledWidth > resultingWidth) {
            scaledHeight = resultingWidth / scaledWidth * scaledHeight;
            scaledWidth = resultingWidth;
        }
        if (this.maxHeight > 0.0f && scaledHeight > this.maxHeight) {
            scaledWidth = this.maxHeight / scaledHeight * scaledWidth;
            scaledHeight = this.maxHeight;
        }
        sizes.x = scaledWidth;
        sizes.y = scaledHeight;
        return sizes;
    }

    private static float $default$scale() {
        return 1.0f;
    }

    protected ImageCell(ImageCellBuilder<?, ?> b) {
        super(b);
        this.scale = b.scale$set ? b.scale$value : ImageCell.$default$scale();
        this.image = b.image;
        if (this.image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.maxHeight = b.maxHeight;
    }

    public static ImageCellBuilder<?, ?> builder() {
        return new ImageCellBuilderImpl();
    }

    public ImageCellBuilder<?, ?> toBuilder() {
        return new ImageCellBuilderImpl().$fillValuesFrom(this);
    }

    public float getScale() {
        return this.scale;
    }

    @NonNull
    public PDImageXObject getImage() {
        return this.image;
    }

    public float getMaxHeight() {
        return this.maxHeight;
    }

    public static abstract class ImageCellBuilder<C extends ImageCell, B extends ImageCellBuilder<C, B>>
    extends AbstractCell.AbstractCellBuilder<C, B> {
        private boolean scale$set;
        private float scale$value;
        private PDImageXObject image;
        private float maxHeight;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ImageCellBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ImageCell instance, ImageCellBuilder<?, ?> b) {
            b.scale(instance.scale);
            b.image(instance.image);
            b.maxHeight(instance.maxHeight);
        }

        public B scale(float scale) {
            this.scale$value = scale;
            this.scale$set = true;
            return (B)this.self();
        }

        public B image(@NonNull PDImageXObject image) {
            if (image == null) {
                throw new NullPointerException("image is marked non-null but is null");
            }
            this.image = image;
            return (B)this.self();
        }

        public B maxHeight(float maxHeight) {
            this.maxHeight = maxHeight;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ImageCell.ImageCellBuilder(super=" + super.toString() + ", scale$value=" + this.scale$value + ", image=" + this.image + ", maxHeight=" + this.maxHeight + ")";
        }
    }

    private static final class ImageCellBuilderImpl
    extends ImageCellBuilder<ImageCell, ImageCellBuilderImpl> {
        private ImageCellBuilderImpl() {
        }

        @Override
        protected ImageCellBuilderImpl self() {
            return this;
        }

        @Override
        public ImageCell build() {
            return new ImageCell(this);
        }
    }
}

