/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.net.MalformedURLException;
import java.net.URL;
import net.glxn.qrgen.core.scheme.Schema;

public class Url
extends Schema {
    private URL url;

    public String getUrl() {
        if (this.url != null) {
            return this.url.toString();
        }
        return null;
    }

    public void setUrl(String url) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            this.url = null;
        }
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.trim().toLowerCase().startsWith("http") && !code.trim().toLowerCase().startsWith("https")) {
            throw new IllegalArgumentException("this is not a valid url code: " + code);
        }
        this.setUrl(code.trim());
        return this;
    }

    @Override
    public String generateString() {
        return this.getUrl();
    }

    public String toString() {
        return this.generateString();
    }

    public static Url parse(String code) {
        Url u = new Url();
        u.parseSchema(code);
        return u;
    }
}

