/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.util.Map;
import net.glxn.qrgen.core.scheme.Schema;
import net.glxn.qrgen.core.scheme.SchemeUtil;

public class SMS
extends Schema {
    private static final String SMS = "sms";
    private String number;
    private String subject;

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.trim().toLowerCase().startsWith(SMS)) {
            throw new IllegalArgumentException("this is not a valid sms code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code.trim().toLowerCase());
        if (parameters.containsKey(SMS)) {
            this.setNumber(parameters.get(SMS));
        }
        if (this.getNumber() != null && parameters.containsKey(this.getNumber())) {
            this.setSubject(parameters.get(this.getNumber()));
        }
        return this;
    }

    @Override
    public String generateString() {
        return "sms:" + this.number + (String)(this.subject != null ? ":" + this.subject : "");
    }

    public String toString() {
        return this.generateString();
    }

    public static SMS parse(String code) {
        SMS sms = new SMS();
        sms.parseSchema(code);
        return sms;
    }
}

