/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import net.glxn.qrgen.core.scheme.BizCard;
import net.glxn.qrgen.core.scheme.EMail;
import net.glxn.qrgen.core.scheme.EnterpriseWifi;
import net.glxn.qrgen.core.scheme.GeoInfo;
import net.glxn.qrgen.core.scheme.Girocode;
import net.glxn.qrgen.core.scheme.GooglePlay;
import net.glxn.qrgen.core.scheme.ICal;
import net.glxn.qrgen.core.scheme.KddiAu;
import net.glxn.qrgen.core.scheme.MMS;
import net.glxn.qrgen.core.scheme.MeCard;
import net.glxn.qrgen.core.scheme.QRCodeSchemeParser;
import net.glxn.qrgen.core.scheme.SMS;
import net.glxn.qrgen.core.scheme.Schema;
import net.glxn.qrgen.core.scheme.Telephone;
import net.glxn.qrgen.core.scheme.Url;
import net.glxn.qrgen.core.scheme.VCard;
import net.glxn.qrgen.core.scheme.Wifi;

public class ExtendableQRCodeSchemeParser
implements QRCodeSchemeParser {
    private Set<QRCodeSchemeParser> parser;

    @Override
    public Set<Class<? extends Schema>> getSupportedSchemes() {
        LinkedHashSet<Class<? extends Schema>> supportedSchemes = new LinkedHashSet<Class<? extends Schema>>();
        for (QRCodeSchemeParser parser : this.getParser()) {
            supportedSchemes.addAll(parser.getSupportedSchemes());
        }
        return supportedSchemes;
    }

    @Override
    public Object parse(String qrCodeText) throws UnsupportedEncodingException {
        for (QRCodeSchemeParser parser : this.getParser()) {
            try {
                return parser.parse(qrCodeText);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
        }
        throw new UnsupportedEncodingException("unkonwn QR code scheme: " + qrCodeText);
    }

    protected Set<QRCodeSchemeParser> getParser() {
        if (this.parser == null) {
            this.parser = this.loadParser();
        }
        return this.parser;
    }

    protected Set<QRCodeSchemeParser> loadParser() {
        LinkedHashSet<QRCodeSchemeParser> result = new LinkedHashSet<QRCodeSchemeParser>();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/qrcode.meta");
            for (URL url : Collections.list(resources)) {
                Properties properties = new Properties();
                InputStream is = url.openStream();
                try {
                    String[] parserNames;
                    properties.load(is);
                    String prop = properties.getProperty(QRCodeSchemeParser.class.getName());
                    for (String className : parserNames = prop.split(",")) {
                        result.add(this.createParserInstance(className));
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load schemes", e);
        }
        result.add(new QRCodeSchemeParserImpl());
        return result;
    }

    protected QRCodeSchemeParser createParserInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = Class.forName(className.trim());
        return (QRCodeSchemeParser)clazz.newInstance();
    }

    static class QRCodeSchemeParserImpl
    implements QRCodeSchemeParser {
        QRCodeSchemeParserImpl() {
        }

        @Override
        public Object parse(String qrCodeText) throws UnsupportedEncodingException {
            for (Class<? extends Schema> type : this.getSupportedSchemes()) {
                Object instance = this.createInstance(qrCodeText, type);
                if (instance == null) continue;
                return instance;
            }
            throw new UnsupportedEncodingException("unkonwn QR code scheme: " + qrCodeText);
        }

        protected Object createInstance(String qrCodeText, Class<? extends Schema> type) {
            try {
                return type.getConstructor(null).newInstance(null).parseSchema(qrCodeText);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Set<Class<? extends Schema>> getSupportedSchemes() {
            LinkedHashSet<Class<? extends Schema>> supportedSchemes = new LinkedHashSet<Class<? extends Schema>>();
            supportedSchemes.add(Girocode.class);
            supportedSchemes.add(VCard.class);
            supportedSchemes.add(Wifi.class);
            supportedSchemes.add(BizCard.class);
            supportedSchemes.add(EMail.class);
            supportedSchemes.add(EnterpriseWifi.class);
            supportedSchemes.add(GeoInfo.class);
            supportedSchemes.add(GooglePlay.class);
            supportedSchemes.add(ICal.class);
            supportedSchemes.add(KddiAu.class);
            supportedSchemes.add(MeCard.class);
            supportedSchemes.add(MMS.class);
            supportedSchemes.add(SMS.class);
            supportedSchemes.add(Telephone.class);
            supportedSchemes.add(Url.class);
            return supportedSchemes;
        }
    }
}

