/*
 * Decompiled with CFR 0.152.
 */
package net.rgielen.fxweaver.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.util.Callback;
import net.rgielen.fxweaver.core.FxControllerAndView;
import net.rgielen.fxweaver.core.FxLoadException;
import net.rgielen.fxweaver.core.FxmlView;
import net.rgielen.fxweaver.core.SimpleFxControllerAndView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxWeaver {
    private static final Logger LOG = LoggerFactory.getLogger(FxWeaver.class);
    private final Callback<Class<?>, Object> beanFactory;
    private final Runnable closeCommand;

    public FxWeaver(Callback<Class<?>, Object> beanFactory, Runnable closeCommand) {
        this.beanFactory = beanFactory;
        this.closeCommand = closeCommand;
    }

    public <C, V extends Node> V loadView(Class<C> controllerClass) {
        return this.loadView(controllerClass, (ResourceBundle)null);
    }

    public <C, V extends Node> V loadView(Class<C> controllerClass, ResourceBundle resourceBundle) {
        return this.loadView(controllerClass, this.buildFxmlReference(controllerClass), resourceBundle);
    }

    public <C, V extends Node> V loadView(Class<C> controllerClass, String location) {
        return this.loadView(controllerClass, location, null);
    }

    public <C, V extends Node> V loadView(Class<C> controllerClass, String location, ResourceBundle resourceBundle) {
        return (V)((Node)this.load(controllerClass, location, resourceBundle).getView().orElse(null));
    }

    public <C> C loadController(Class<C> controllerClass, String location) {
        return this.loadController(controllerClass, location, null);
    }

    public <C> C loadController(Class<C> controllerClass, String location, ResourceBundle resourceBundle) {
        return this.load(controllerClass, location, resourceBundle).getController();
    }

    public <C> C loadController(Class<C> controllerClass) {
        return this.loadController(controllerClass, (ResourceBundle)null);
    }

    public <C> C loadController(Class<C> controllerClass, ResourceBundle resourceBundle) {
        return this.load(controllerClass, resourceBundle).getController();
    }

    public <C> C getBean(Class<C> beanType) {
        return beanType.cast(this.beanFactory.call(beanType));
    }

    public <C, V extends Node> FxControllerAndView<C, V> load(Class<C> controllerClass) {
        return this.load(controllerClass, null);
    }

    public <C, V extends Node> FxControllerAndView<C, V> load(Class<C> controllerClass, ResourceBundle resourceBundle) {
        return this.load(controllerClass, this.buildFxmlReference(controllerClass), resourceBundle);
    }

    protected <C, V extends Node> FxControllerAndView<C, V> load(Class<C> controllerClass, String location, ResourceBundle resourceBundle) {
        return Optional.ofNullable(location).map(controllerClass::getResource).map(url -> this.loadByView((URL)url, resourceBundle)).orElseGet(() -> SimpleFxControllerAndView.ofController(this.getBean(controllerClass)));
    }

    private <C, V extends Node> FxControllerAndView<C, V> loadByView(URL url, ResourceBundle resourceBundle) {
        return this.loadByViewUsingFxmlLoader(new FXMLLoader(), url, resourceBundle);
    }

    <C, V extends Node> FxControllerAndView<C, V> loadByViewUsingFxmlLoader(FXMLLoader loader, URL url, ResourceBundle resourceBundle) {
        FxControllerAndView<Object, Node> fxControllerAndView;
        block9: {
            InputStream fxmlStream = url.openStream();
            try {
                LOG.debug("Loading FXML resource at {}", (Object)url);
                loader.setLocation(url);
                loader.setControllerFactory(this.beanFactory);
                if (resourceBundle != null) {
                    loader.setResources(resourceBundle);
                }
                Node view = (Node)loader.load(fxmlStream);
                fxControllerAndView = SimpleFxControllerAndView.of(loader.getController(), view);
                if (fxmlStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fxmlStream != null) {
                        try {
                            fxmlStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FxLoadException("Unable to load FXML file " + String.valueOf(url), e);
                }
            }
            fxmlStream.close();
        }
        return fxControllerAndView;
    }

    protected String buildFxmlReference(Class<?> c) {
        return Optional.ofNullable(c.getAnnotation(FxmlView.class)).map(FxmlView::value).map(s -> s.isEmpty() ? null : s).orElse(c.getSimpleName() + ".fxml");
    }

    public void shutdown() {
        this.closeCommand.run();
        Platform.exit();
    }
}

